---
description: "Learn more about: Date and time functions"
title: "Date and time functions (DAX) | Microsoft Docs"
---
# Date and time functions

These functions help you create calculations based on dates and time. Many of the functions in DAX are similar to the Excel date and time functions. However, DAX functions use a **datetime** data type, and can take values from a column as an argument.  
  
## In this category

|Function  |Description  |
|---------|---------|
|[CALENDAR](calendar-function-dax.md)     |   Returns a table with a single column named "Date" that contains a contiguous set of dates.      |
|[CALENDARAUTO](calendarauto-function-dax.md)       |   Returns a table with a single column named "Date" that contains a contiguous set of dates.      |
|[DATE](date-function-dax.md)      |   Returns the specified date in datetime format.       |
|[DATEDIFF](datediff-function-dax.md)     |  Returns the number of interval boundaries between two dates.         |
|[DATEVALUE](datevalue-function-dax.md)     |   Converts a date in the form of text to a date in datetime format.       |
|[DAY](day-function-dax.md)     |   Returns the day of the month, a number from 1 to 31.       |
|[EDATE](edate-function-dax.md)     |   Returns the date that is the indicated number of months before or after the start date.      |
|[EOMONTH](eomonth-function-dax.md)    |  Returns the date in datetime format of the last day of the month, before or after a specified number of months.       |
|[HOUR](hour-function-dax.md)     |  Returns the hour as a number from 0 (12:00 A.M.) to 23 (11:00 P.M.).       |
|[MINUTE](minute-function-dax.md)     |   Returns the minute as a number from 0 to 59, given a date and time value.        |
|[MONTH](month-function-dax.md)      |  Returns the month as a number from 1 (January) to 12 (December).        |
|[NETWORKDAYS](networkdays-function-dax.md)| Returns the number of whole workdays between two dates. |
|[NOW](now-function-dax.md)     |  Returns the current date and time in datetime format.        |
|[QUARTER](quarter-function-dax.md)     |  Returns the quarter as a number from 1 to 4.       |
|[SECOND](second-function-dax.md)     |  Returns the seconds of a time value, as a number from 0 to 59.        |
|[TIME](time-function-dax.md)     |  Converts hours, minutes, and seconds given as numbers to a time in datetime format.       |
|[TIMEVALUE](timevalue-function-dax.md)     |  Converts a time in text format to a time in datetime format.       |
|[TODAY](today-function-dax.md)     |   Returns the current date.      |
|[UTCNOW](utcnow-function-dax.md)     |   Returns the current UTC date and time      |
|[UTCTODAY](utctoday-function-dax.md)     |   Returns the current UTC date.      |
|[WEEKDAY](weekday-function-dax.md)     |  Returns a number from 1 to 7 identifying the day of the week of a date.       |
|[WEEKNUM](weeknum-function-dax.md)      |  Returns the week number for the given date and year according to the return_type value.       |
|[YEAR](year-function-dax.md)     |    Returns the year of a date as a four digit integer in the range 1900-9999.     |
|[YEARFRAC](yearfrac-function-dax.md)      |    Calculates the fraction of the year represented by the number of whole days between two dates.      |
